/* 
 * File:   eeprom.c
 * Author: LaV
 * Comments:
 * Revision history: 1
 */
#include "eeprom.h"

unsigned char ee_read(unsigned char addr){
    EEADR = addr;
    EEPGD = 0;//выбор типа памяти - EEPROM
    CFGS = 0;//обращение не к регистрам конфигурации
    RD = 1;
    while(RD)continue;
    return EEDATA;
}
void ee_write(unsigned char addr, unsigned char data){
    EEADR = addr;
    EEDATA = data;
    EEPGD = 0;
    CFGS = 0;
    WREN = 1;
    GIE = 0;
    EECON2 = 0x55;
    EECON2 = 0xAA;
    WR = 1;
    while(WR)continue;
    GIE = 1;
    WREN = 0;
}
